/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.common.casting.actions.matrices;

import at.petrak.hexcasting.api.casting.castables.ConstMediaAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jblas.DoubleMatrix;
import org.jblas.ranges.Range;
import org.jblas.ranges.RangeUtils;
import org.jetbrains.annotations.NotNull;
import ram.talia.moreiotas.api.OperatorUtilsKt;
import ram.talia.moreiotas.api.matrices.HoleyIntervalRange;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lram/talia/moreiotas/common/casting/actions/matrices/OpDeterminantMatrix;", "Lat/petrak/hexcasting/api/casting/castables/ConstMediaAction;", "Lorg/jblas/DoubleMatrix;", "mat", "", "determinant", "(Lorg/jblas/DoubleMatrix;)D", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Ljava/util/List;", "", "argc", "I", "getArgc", "()I", "<init>", "()V", "moreiotas-fabric-1.20.1"})
public final class OpDeterminantMatrix
implements ConstMediaAction {
    @NotNull
    public static final OpDeterminantMatrix INSTANCE = new OpDeterminantMatrix();
    private static final int argc = 1;

    private OpDeterminantMatrix() {
    }

    public int getArgc() {
        return argc;
    }

    private final double determinant(DoubleMatrix mat) {
        if (mat.isScalar()) {
            return mat.scalar();
        }
        double sum = 0.0;
        DoubleMatrix matWithoutTop = mat.getRows(RangeUtils.interval((int)1, (int)mat.rows));
        int n = mat.rows;
        for (int i = 0; i < n; ++i) {
            double d = Math.pow(-1.0, i) * mat.get(0, i);
            DoubleMatrix doubleMatrix = matWithoutTop.getColumns((Range)new HoleyIntervalRange(0, mat.columns, i));
            Intrinsics.checkNotNullExpressionValue((Object)doubleMatrix, (String)"matWithoutTop.getColumns\u2026Range(0, mat.columns, i))");
            sum += d * this.determinant(doubleMatrix);
        }
        return sum;
    }

    @NotNull
    public List<Iota> execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Object[] $this$asMatrix$iv = OperatorUtilsKt.getNumOrVecOrMatrix(args, 0, this.getArgc());
        boolean $i$f$getAsMatrix = false;
        DoubleMatrix mat = (DoubleMatrix)$this$asMatrix$iv.flatMap(OperatorUtilsKt.asMatrix.2.INSTANCE, OperatorUtilsKt.asMatrix.3.INSTANCE, OperatorUtilsKt.asMatrix.4.INSTANCE);
        if (!mat.isSquare()) {
            throw MishapInvalidIota.Companion.ofType(args.get(0), 0, "matrix.square");
        }
        if (mat.columns > 4) {
            $this$asMatrix$iv = new Object[]{4, 4, mat.columns, mat.rows};
            throw MishapInvalidIota.Companion.of(args.get(0), 0, "matrix.max_size", $this$asMatrix$iv);
        }
        double $this$asActionResult$iv = this.determinant(mat);
        boolean $i$f$getAsActionResult = false;
        return CollectionsKt.listOf((Object)new DoubleIota($this$asActionResult$iv));
    }

    public long getMediaCost() {
        return ConstMediaAction.DefaultImpls.getMediaCost((ConstMediaAction)this);
    }

    @NotNull
    public ConstMediaAction.CostMediaActionResult executeWithOpCount(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        return ConstMediaAction.DefaultImpls.executeWithOpCount((ConstMediaAction)this, args, (CastingEnvironment)env);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return ConstMediaAction.DefaultImpls.operate((ConstMediaAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }
}

